<?php
date_default_timezone_set('Asia/Kolkata');

/* ===============================
   GET MOST ACCURATE IP POSSIBLE
=============================== */
function getUserIP() {
    $keys = [
        'HTTP_CF_CONNECTING_IP', // Cloudflare
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_REAL_IP',
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    ];

    foreach ($keys as $key) {
        if (!empty($_SERVER[$key])) {
            $ip = explode(',', $_SERVER[$key])[0];
            return trim($ip);
        }
    }
    return 'UNKNOWN';
}

/* ===============================
   DATA TO SEND
=============================== */
$data = [
    "client_name"  => "Search Homes India",
    "project_name" => "Godrej Nexspace Panvel",
    "source"       => "Google Search Ads",
    "ip_address"   => getUserIP()
];

/* ===============================
   SEND TO GOOGLE SHEET
=============================== */
$webhook_url = "https://script.google.com/macros/s/AKfycbwra7dNQjX-v1VqaUwuvp91eWvLeq_ibvX-b3bRVqB3uNd1Omv2suvdRnSDdlZkCi_u/exec";

$ch = curl_init($webhook_url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
    CURLOPT_POSTFIELDS     => json_encode($data),
    CURLOPT_TIMEOUT        => 3
]);
curl_exec($ch);
curl_close($ch);