<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You</title>
    <link rel="icon" href="./img/godrejfavicon.png" type="image/x-icon">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #ffffff 0%, #fef7f7 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333333;
            line-height: 1.6;
        }

        .container {
            text-align: center;
            max-width: 600px;
            padding: 3rem 2rem;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            border: 2px solid #ffebee;
        }

        .checkmark {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #ffcdd2;
            margin: 0 auto 2rem;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            animation: pulse 2s infinite;
        }

        .checkmark::after {
            content: '✓';
            font-size: 2.5rem;
            color: #d32f2f;
            font-weight: bold;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }

        h1 {
            font-size: 2.5rem;
            color: #d32f2f;
            margin-bottom: 1rem;
            font-weight: 300;
            letter-spacing: -1px;
        }

        .subtitle {
            font-size: 1.2rem;
            color: #666666;
            margin-bottom: 2rem;
            font-weight: 300;
        }

        .message {
            font-size: 1rem;
            color: #555555;
            margin-bottom: 2.5rem;
            line-height: 1.8;
        }

        .button-group {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn {
            padding: 0.75rem 2rem;
            border: none;
            border-radius: 50px;
            font-size: 1rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .btn-primary {
            background: #d32f2f;
            color: white;
        }

        .btn-primary:hover {
            background: #b71c1c;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(211, 47, 47, 0.3);
        }

        .btn-secondary {
            background: white;
            color: #d32f2f;
            border: 2px solid #ffcdd2;
        }

        .btn-secondary:hover {
            background: #ffebee;
            border-color: #d32f2f;
            transform: translateY(-2px);
        }

        .decorative-line {
            width: 60px;
            height: 3px;
            background: #ffcdd2;
            margin: 2rem auto;
            border-radius: 2px;
        }

        @media (max-width: 768px) {
            .container {
                margin: 1rem;
                padding: 2rem 1.5rem;
            }

            h1 {
                font-size: 2rem;
            }

            .subtitle {
                font-size: 1.1rem;
            }

            .button-group {
                flex-direction: column;
                align-items: center;
            }

            .btn {
                width: 100%;
                max-width: 250px;
            }
        }

        .footer-text {
            margin-top: 2rem;
            font-size: 0.9rem;
            color: #999999;
        }
        ._header {
        
            text-align: center;
        }

        ._header .logo {
            max-width: 200px;
            margin: 0 auto 20px;
        }

        ._header .logo img {
            width: 100%;
        }

        ._header h1 {
            font-size: 65px;
            font-weight: 800;
            color: white;
            margin: 0;
        }
    </style>
</head>
<body>

    <div class="container">
        
        <div class="_header">
            <div class="logo">
                <img src="./img/logo.webp" alt="">
            </div>
        </div>
        
        <div class="checkmark"></div>
        
        <h1>Thank You!</h1>
        
        <p class="subtitle">Your submission has been received</p>
        
        <div class="decorative-line"></div>
        
        <p class="message">
            We appreciate you taking the time to reach out to us. 
            Your message is important to us and we'll get back to you as soon as possible.
        </p>
        
        <div class="button-group">
            <a href="https://godrejprojects.site/nexspace-panvel/" class="btn btn-primary">Return Home</a>
        </div>
        
  
    </div>
</body>
</html>