<!DOCTYPE html>
<html>

<head>
    <title>We Are Committed To Protecting Your Privacy</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@200;300;400;600;700;800;900&display=swap"
        rel="stylesheet">
    <style type="text/css">
        body {
            font-family: 'Nunito', sans-serif;
            box-sizing: border-box;
            padding: 80px 0;
            text-align: left;
            width: 100%;
            overflow-x: hidden;
        }

        img {
            width: 200px;
        }

        h2 {
            font-size: 1.2rem;
        }

        .container {
            width: 100%;
            max-width: 1190px;
            margin: 0 auto;
        }

        .InnerSection {
            display: table;
            width: 700px;
            margin: 0 auto;
        }

        .InnerSection img {
            width: 100%;
            max-width: 500px;
        }

        h1 {
            width: 100%;
            display: inline-block;
            text-align: left;
            margin-bottom: 0;
            line-height: 60px;
            font-size: 25px;
            font-weight: 700;
        }

        h6 {
            color: #fff;
            font-size: 16px;
            margin-top: 0;
        }

        a {
            padding: 10px 20px;
            border-radius: 10px;
            text-align: center;
            line-height: 20px;
            font-size: 16px;
            border-width: 1px !important;
            border-style: solid !important;
            display: inline-block;
            color: inherit;
            color: #049b5a !important;
            border-color: #049b5a !important;
            background-color: #ffffff !important;
        }

        @media(max-width: 767px) {
            body {
                padding: 25vh 7%;
            }

            h1 {
                font-size: 2em;
                line-height: normal;
            }

            .InnerSection {
                width: 100%;
            }
        }
    </style>
</head>

<body>

    <section className="PageNotfound">
        <div class="container">
            <img src="./assets/images/logo.webp">
            <h1>We Are Committed To Protecting Your Privacy</h1>
            <p>
                <b>
                    We collect the minimum amount of information about you that is commensurate with providing you with
                    a satisfactory service. This policy indicates the type of processes that may result in data being
                    collected about you. Your use of this website gives us the right to collect that information.
                </b>
            </p>
            <div class="w-100">
                <h2>Information Collected</h2>
                <p>We may collect any or all of the information that you give us depending on the type of transaction
                    you enter into, including your name, address, telephone number, and email address, together with
                    data about your use of the website. Other information that may be needed from time to time to
                    process a request may also be collected as indicated on the website.</p>
            </div>
            <div class="w-100">
                <h2>Information Use</h2>
                <p>We use the information collected primarily to process the task for which you visited the website. All
                    reasonable precautions are taken to prevent unauthorised access to this information. This safeguard
                    may require you to provide additional forms of identity should you wish to obtain information about
                    your account details.</p>
            </div>
            <div class="w-100">
                <h2>Cookies</h2>
                <p>Your Internet browser has the in-built facility for storing small files - "cookies" - that hold
                    information which allows a website to recognise your account. Our website takes advantage of this
                    facility to enhance your experience. You have the ability to prevent your computer from accepting
                    cookies but, if you do, certain functionality on the website may be impaired.</p>
            </div>
            <div class="w-100">
                <h2>Disclosing Information</h2>
                <p>We do not disclose any personal information obtained about you from this website to third parties
                    unless you permit us to do so by ticking the relevant boxes in registration or competition forms. We
                    may also use the information to keep in contact with you and inform you of developments associated
                    with us. You will be given the opportunity to remove yourself from any mailing list or similar
                    device. If at any time in the future we should wish to disclose information collected on this
                    website to any third party, it would only be with your knowledge and consent.</p>
                <p>We may from time to time provide information of a general nature to third parties - for example, the
                    number of individuals visiting our website or completing a registration form, but we will not use
                    any information that could identify those individuals.</p>
                <p>In addition we may work with third parties for the purpose of delivering targeted behavioural
                    advertising to the website. Through the use of cookies, anonymous information about your use
                    of our websites and other websites will be used to provide more relevant adverts about goods and
                    services of interest to you. For more information on online behavioural advertising and about how to
                    turn this feature off.</p>
            </div>
            <div class="w-100">
                <h2>Changes to this Policy</h2>
                <p>Any changes to our Privacy Policy will be placed here and will supersede this version of our policy.
                    We will take reasonable steps to draw your attention to any changes in our policy. However, to be on
                    the safe side, we suggest that you read this document each time you use the website to ensure that
                    it still meets with your approval.</p>
            </div>
            <div class="w-100">
                <h2>Contacting Us</h2>
                <p>If you have any questions about our Privacy Policy, or if you want to know what information we have
                    collected about you. You can also correct
                    any factual errors in that information or require us to remove your details form any list under our
                    control. Certain services, such as a statement of accounts depend on a continuous connection to the
                    database. We makes no assurance, representation, promise
                    whatsoever that such connectivity will always be available.</p>
            </div>
            <div class="w-100">
                <a href="/" style="text-decoration: none;">Go to Home Page</a>
            </div>
        </div>

    </section>
</body>

</html>