<?php include 'visitors.php'; ?>
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Godrej Nexspace Panvel, Mumbai, Premium office starts at ₹79L*</title>
    <meta name="description"
        content="Launching soon, NEXSPACE at Godrej City Panvel offers Grade A offices in a 145-acre township, lease-managed by Godrej, starting at ₹79 Lacs with EOI open.">
    <meta name="keywords"
        content="Godrej Nexspace, Godrej Nexspace, Godrej City Panvel, commercial property Panvel, Grade A offices, office space Panvel, Navi Mumbai commercial, Mumbai 3.0 offices, NMIA commercial hub, Godrej commercial spaces, Panvel business district, managed office spaces, lease managed offices, premium office investment, EOI open Panvel, Godrej Properties commercial, mixed-use township Panvel, office near airport, Panvel real estate, commercial investment Navi Mumbai">
    <link rel="shortcut icon" href="./img/godrejfavicon.png" type="image/x-icon">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/slick-theme.min.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css" rel="stylesheet">
    <style>
        .iti {
            width: 100%
        }

        .contact_section .iti--separate-dial-code .iti__selected-flag {
            background-color: #fff !important
        }

        .form_section.slide-form .iti__selected-dial-code {
            color: #fff !important;
        }

        /* Submit button loading state */
        .submit-btn {
            position: relative;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .submit-btn.disabled {
            pointer-events: none;
            opacity: 0.7;
        }

        /* Loader circle */
        .btn-loader {
            display: none;
            width: 16px;
            height: 16px;
            margin-left: 8px;
            border: 2px solid #fff;
            border-top-color: transparent;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        .submit-btn.loading .btn-loader {
            display: inline-block;
        }

        /* Spinner animation */
        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Honeypot hidden safely */
        .b-user-message {
            position: absolute;
            left: -9999px;
        }
    </style>
</head>

<body>
    <!-- Header -->
    <div class="header" id="header">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-3 col-6">
                    <button class="menu-btn" id="menuBtn" onclick="openMenu()">
                        <div class="hamburger" id="hamburger">
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>
                        <span>MENU</span>
                    </button>
                </div>
                <div class="col-md-6 col-6 text-md-center text-end">
                    <div class="logo">
                        <a class="navbar-brand" href="#">
                            <img src="img/logo.webp" alt="logo" class="img-fluid" loading="lazy">
                        </a>
                    </div>
                </div>
                <!-- <div class="col-md-3 text-end">
                    <div class="phone-email">
                        <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">Contact our Approved Representative </button>
                    </div>
                </div> -->
            </div>
        </div>
    </div>
    <!-- Overlay -->
    <div class="overlay" id="overlay" onclick="closeMenu()"></div>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <button class="close-btn" onclick="closeMenu()">&times;</button>
        <ul class="menu-items">
            <li class="nav-item">
                <a class="nav-link nav-link-custom active" href="#overview">Overview</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#highlight">Highlight</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#price">Price List</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#amenities">Amenities</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#floor">Floor Plan</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#location">Location</a>
            </li>
            <li class="nav-item">
                <a class="nav-link nav-link-custom" href="#gallery">Gallery</a>
            </li>
        </ul>
    </div>
    <!-- banner section start -->
    <div class="slider_section">
        <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000">

            <!-- Indicators -->
            <!-- <div class="carousel-indicators">
                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>

                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div> -->

            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img src="img/banner/b1.webp" alt="Godrej Nexspace Panvel" class="slider-img d_sm_none"
                        loading="lazy">
                    <img src="img/banner/b1m.webp" alt="Godrej Nexspace Panvel" class="slider-img d_sm_block"
                        loading="lazy">
                </div>
            </div>
            <div class="content_over_banner">
                <div class="project_box">
                    <h2 class="invest_in">Launching Soon</h2>
                    <h1 class="pro_name" style="color:#e9046f">Godrej Nexspace</h1>
                    <p>
                        <img src="img/icons/location.png" alt="Godrej Nexspace Panvel">
                        At Godrej City, Panvel
                    </p>
                    <h3>Grade A Commercial Spaces <span>Starts ₹79 Lacs*</span></h3>
                    <ul>
                        <li>
                            <img src="img/icons/arrowUp.png" alt="Godrej Nexspace" loading="lazy">
                            Lease Managed By Godrej Properties
                        </li>
                        <li>
                            <img src="img/icons/arrowUp.png" alt="Godrej Nexspace" loading="lazy">
                            145-acre Mixed-Use Township
                        </li>
                        <li>
                            <img src="img/icons/arrowUp.png" alt="Godrej Nexspace" loading="lazy">
                            EOI Starts From ₹ 45,000
                        </li>
                        <li>
                            <img src="img/icons/arrowUp.png" alt="Godrej Nexspace" loading="lazy">
                            Limited Period Payment Plan – 25:25:25:25
                        </li>
                        <li>
                            <img src="img/icons/arrowUp.png" alt="Godrej Nexspace" loading="lazy">
                            EOI Is Open Now!
                        </li>
                    </ul>
                    <div class="mt-4">
                        <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">
                            Enquire Now
                        </button>
                    </div>
                </div>

                <div class="form_section slide-form">
                    <div class="row">
                        <div class="col-12">
                            <button class="form-close-btn">&times;</button>
                            <h6>Talk to Our Property Specialist</h6>
                        </div>
                        <form method="post" action="micrositeleads.php" id="form1">

                            <!-- Name -->
                            <input autocomplete="off" name="name" id="qSenderName_popup"
                                class="form-control popup_form mb-4" placeholder="Your Full Name"
                                pattern="[a-zA-Z ]{4,35}" required />

                            <!-- Email -->
                            <input autocomplete="off" name="email" id="qEmail_popup"
                                class="form-control popup_form mb-4" placeholder="Email Address" type="email"
                                required />

                            <!-- Phone -->
                            <input autocomplete="off" name="phone" id="qPhone_popup"
                                class="form-control popup_form mb-4" placeholder="Phone Number" pattern="[0-9]{10}"
                                maxlength="10" required />

                            <!-- Hidden Fields -->
                            <input type="hidden" name="projectname" value="GPanvel" />
                            <input type="hidden" name="form_source" value="Google Ads" />

                            <!-- Submit -->
                            <div class="col-lg-12 form-group text-center mb-3">
                                <div class="advanced-button">
                                    <button class="button lg_btn submit-btn" type="submit" name="submit">
                                        <span class="btn-text">GET CALL BACK</span>
                                        <span class="btn-loader" aria-hidden="true"></span>
                                    </button>

                                    <!-- Honeypot -->
                                    <div class="form-group b-user-message">
                                        <input id="USER_MESSAGE" type="text" name="USER_MESSAGE" tabindex="-1" value=""
                                            autocomplete="off" />
                                    </div>
                                </div>
                            </div>

                            <div class="form-response"></div>
                        </form>
                        <div class="col-12">
                            <div class="inp-box d-flex">
                                <input type="checkbox" checked="" id="vehicle1" name="vehicle1" value="form-checkbox"
                                    style="width: 15px; margin-right: 8px;">
                                <label for="vehicle1" class="inp-txt black" style="font-size: 10px; color: #fff;"> I
                                    authorize company representatives to
                                    Call, SMS, Email or WhatsApp me about its products and offers. This consent
                                    overrides any registration for DNC/NDNC.</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <button class="form-toggle-btn">Book A Free Site Visit</button>
    </div>


    <!-- overview section starts here -->
    <section class="overview_section" id="overview" data-aos="fade-up" data-aos-duration="400" data-aos-delay="200">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="section_title">Overview</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>
                <div class="col-12">
                    <p class="para">
                        Godrej Nexspace at Godrej City, Panvel emerges as a refined business destination crafted for
                        enterprises that value efficiency, flexibility, and long-term growth. Set within a thriving
                        145-acre mixed-use township, these Grade A commercial offices offer spacious, well-designed
                        units with the option to combine select spaces for scalable operations. Thoughtfully planned
                        layouts ensure abundant natural light, serene views, and seamless functionality, complemented by
                        dedicated parking and modern utility zones. A grand double-height lobby, concierge desk,
                        high-speed elevators, and an exclusive drop-off zone deliver a premium arrival experience. With
                        centralized air-conditioning, 12-ft floor-to-floor height, expansive glazing, and proximity to
                        the Navi Mumbai International Airport, Godrej Nexspace positions your business at the heart of
                        Mumbai 3.0’s next growth wave.
                    </p>
                </div>
            </div>
        </div>
    </section>
    <!--highlight section -->
    <section class="highlight_section" id="highlight">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="section_title">Highlights</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>
            </div>
            <div class="features-container">
                <div class="row justify-content-center">
                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>1</span></div>
                                <p class="feature-description">Grade-A offices within a 145-acre integrated township</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="100">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>2</span></div>
                                <p class="feature-description">Just 20 mins* from Navi Mumbai International Airport</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="200">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>3</span></div>
                                <p class="feature-description">Grand double-height entrance lobby with concierge</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="300">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>4</span></div>
                                <p class="feature-description">Flexible & combinable office units for growing businesses
                                </p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="400">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>5</span></div>
                                <p class="feature-description">12-ft floor-to-floor height for spacious workspaces</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="500">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>6</span></div>
                                <p class="feature-description">Large 8×8 ft glazed windows for natural light & views</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="600">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>7</span></div>
                                <p class="feature-description">Centralized air-conditioning with efficient layouts</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="700">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>8</span></div>
                                <p class="feature-description">High-speed elevators with exclusive office access</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="800">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>9</span></div>
                                <p class="feature-description">Dedicated parking & smooth drop-off zones</p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-6 mb-4" data-aos="fade-up" data-aos-duration="400"
                        data-aos-delay="900">
                        <div class="feature-card-wrapper">
                            <div class="feature-card">
                                <div class="feature-icon"><span>10</span></div>
                                <p class="feature-description">Cafeteria, conference rooms & modern business amenities
                                </p>
                            </div>
                            <div class="connector-line d-none d-lg-block"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- price list section -->
    <section class="price_list_section" id="price">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-12 align-self-center">
                    <h2 class="section_title">Price List</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                    <!-- <p class="subheading_inclu mb-5">(All Inclusive Including TDS & GST)</p> -->
                </div>
                <div class="col-md-12 col-12">
                    <div class="row justify-content-center">
                        <div class="col-md-4 col-12" data-aos="fade-right" data-aos-duration="800">
                            <div class="price_box">
                                <h6>Type: Office Space</h6>
                                <h5>Size: 400 Sq. Ft.</h5>
                                <p>Price: <span>₹79 L*</span></p>
                                <div>
                                    <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">View
                                        More</button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-12" data-aos="fade-up" data-aos-duration="800">
                            <div class="price_box">
                                <h6>Type: Office Space</h6>
                                <h5>Size: 500 Sq. Ft.</h5>
                                <p>Price: <span>₹99 L*</span></p>
                                <div>
                                    <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">View
                                        More</button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4 col-12" data-aos="fade-left" data-aos-duration="800">
                            <div class="price_box">
                                <h6>Type: Office Space</h6>
                                <h5>Size: 800 Sq. Ft.</h5>
                                <p>Price: <span>₹1.59 Cr*</span></p>
                                <div>
                                    <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">View
                                        More</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- amenities section  -->
    <section class="amenities_section" id="amenities">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="section_title">Amenities</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>

                <!-- ===== DESKTOP VIEW ===== -->
                <div class="col-4 align-self-center pe-0 d_view">
                    <ul class="amenity_list">
                        <li class="amenity-box">
                            <img src="img/amenities/swimming-pool.png" loading="lazy">
                            <span>Swimming Pool</span>
                        </li>
                        <li class="amenity-box">
                            <img src="img/amenities/movie.png" loading="lazy">
                            <span>Mini Theatre</span>
                        </li>
                    </ul>
                </div>

                <div class="col-4 p-0 d_view">
                    <ul>
                        <li class="amenity-box">
                            <img src="img/amenities/playground.png" loading="lazy">
                            <span>Kids Play Area</span>
                        </li>
                        <li class="amenity-box">
                            <img src="img/amenities/yoga.png" loading="lazy">
                            <span>Yoga</span>
                        </li>
                        <li class="amenity-box">
                            <img src="img/amenities/hall.png" loading="lazy">
                            <span>Banquet Hall</span>
                        </li>
                        <li class="amenity-box">
                            <img src="img/amenities/weight.png" loading="lazy">
                            <span>Gym</span>
                        </li>
                    </ul>
                </div>

                <div class="col-4 align-self-center ps-0 d_view">
                    <ul class="amenity_list">
                        <li class="amenity-box">
                            <img src="img/amenities/running-track.png" loading="lazy">
                            <span>Jogging Track</span>
                        </li>
                        <li class="amenity-box">
                            <img src="img/amenities/sport.png" loading="lazy">
                            <span>Outdoor Games</span>
                        </li>
                    </ul>
                </div>

                <!-- ===== MOBILE VIEW (SAME AMENITIES) ===== -->
                <div class="col-12 m_view">
                    <ul>
                        <li class="amenity-box"><img src="img/amenities/swimming-pool.png"><span>Swimming Pool</span>
                        </li>
                        <li class="amenity-box"><img src="img/amenities/movie.png"><span>Mini Theatre</span></li>
                        <li class="amenity-box"><img src="img/amenities/playground.png"><span>Kids Play Area</span></li>
                        <li class="amenity-box"><img src="img/amenities/yoga.png"><span>Yoga</span></li>
                        <li class="amenity-box"><img src="img/amenities/hall.png"><span>Banquet Hall</span></li>
                        <li class="amenity-box"><img src="img/amenities/weight.png"><span>Gym</span></li>
                        <li class="amenity-box"><img src="img/amenities/running-track.png"><span>Jogging Track</span>
                        </li>
                        <li class="amenity-box"><img src="img/amenities/sport.png"><span>Outdoor Games</span></li>
                    </ul>
                </div>

            </div>
        </div>
    </section>

    <!-- decision corner -->
    <section class="decision_corner">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h4 class="section_title">Ready to upgrade your business address in Panvel with Godrej Properties?
                    </h4>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                    <div class="flex_div d-flex">
                        <div class="boxes">
                            <button class="button" data-bs-toggle="modal" data-bs-target="#enquireModal">Contact
                                us</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--  <section class="bg-light">
        <div class="container py-5">
            <div class="row">
                <div class="col-12">
                    <h2 class="section_title">LANDSCAPE MASTERPLAN STRATEGY</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Celebration Garden</p>
                            <img src="img/garden/celebration-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Woodland Garden</p>
                            <img src="img/garden/Woodland-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Flower Garden</p>
                            <img src="img/garden/flower-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Rock Garden</p>
                            <img src="img/garden/rock-garden.webp" alt="Godrej Nexspace Panvel" width="100%" height="100%"
                                class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Moon Garden</p>
                            <img src="img/garden/moon-garden.webp" alt="Godrej Nexspace Panvel" width="100%" height="100%"
                                class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Edible Garden</p>
                            <img src="img/garden/edible-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Orchard</p>
                            <img src="img/garden/orchard-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Sculpture Garden</p>
                            <img src="img/garden/scuplture-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Sensory Garden</p>
                            <img src="img/garden/scuplture-garden.webp" alt="Godrej Nexspace Panvel" width="100%"
                                height="100%" class="rounded-3" loading="lazy">

                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-12 mt-3">
                        <div class="p-3 shadow rounded-3">
                            <p class="m-0 text-center mb-2 fw-bold">Rain Garden</p>
                            <img src="img/garden/Rain-garden.webp" alt="Godrej Nexspace Panvel" width="100%" height="100%"
                                class="rounded-3" loading="lazy">

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section> -->

    <!-- floor plan section -->
    <section class="floor_section" id="floor">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="section_title">Floor Plan</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>

                <div class="col-12">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="all-tab" data-bs-toggle="tab" data-bs-target="#all-pane"
                                type="button" role="tab" aria-controls="all-pane" aria-selected="true">
                                All
                            </button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="master-tab" data-bs-toggle="tab" data-bs-target="#master-pane"
                                type="button" role="tab" aria-controls="master-pane" aria-selected="false">
                                MASTERPLAN
                            </button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="floor-tab" data-bs-toggle="tab" data-bs-target="#floor-pane"
                                type="button" role="tab" aria-controls="floor-pane" aria-selected="false">
                                FLOORPLAN
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">

                        <!-- ALL -->
                        <div class="tab-pane fade show active" id="all-pane" role="tabpanel" aria-labelledby="all-tab">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-md-4 col-12">
                                        <div class="floor_image">
                                            <img src="img/master-plan.webp" class="img-fluid" style="filter: blur(5px);"
                                                loading="lazy">
                                            <h5>Master Plan</h5>
                                            <span data-bs-toggle="modal" data-bs-target="#enquireModal">
                                                View Master Plan
                                            </span>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-12">
                                        <div class="floor_image">
                                            <img src="img/master-plan.webp" class="img-fluid" style="filter: blur(5px);"
                                                loading="lazy">
                                            <h5>Floor Plan</h5>
                                            <span data-bs-toggle="modal" data-bs-target="#enquireModal">
                                                View Floor Plan
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- MASTER PLAN -->
                        <div class="tab-pane fade" id="master-pane" role="tabpanel" aria-labelledby="master-tab">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-md-4 col-12">
                                        <div class="floor_image">
                                            <img src="img/master-plan.webp" class="img-fluid" style="filter: blur(5px);"
                                                loading="lazy">
                                            <h5>Master Plan</h5>
                                            <span data-bs-toggle="modal" data-bs-target="#enquireModal">
                                                View Master Plan
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- FLOOR PLAN -->
                        <div class="tab-pane fade" id="floor-pane" role="tabpanel" aria-labelledby="floor-tab">
                            <div class="container">
                                <div class="row justify-content-center">
                                    <div class="col-md-4 col-12">
                                        <div class="floor_image">
                                            <img src="img/master-plan.webp" class="img-fluid" style="filter: blur(5px);"
                                                loading="lazy">
                                            <h5>Floor Plan</h5>
                                            <span data-bs-toggle="modal" data-bs-target="#enquireModal">
                                                View Floor Plan
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <style>
        .location_section {
            padding: 80px 0;
        }

        .map_box {
            min-height: 420px;
        }

        .location_content {
            padding-left: 40px;
            max-width: 520px;
        }

        .location_list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .location_list li {
            margin-bottom: 27px;
            font-size: 16px;
            line-height: 1.6;
        }

        @media (max-width: 767px) {
            .location_content {
                padding-left: 0;
                margin-top: 30px;
            }
        }
    </style>
    <!-- location section -->
    <section class="location_section" id="location">
        <div class="container">
            <div class="row mb-4">
                <div class="col-12 text-center">
                    <h2 class="section_title">Location Advantage</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>
            </div>

            <div class="row align-items-center">

                <!-- LEFT: GOOGLE MAP -->
                <div class="col-lg-6 col-md-12 mb-4 mb-lg-0">
                    <div class="map_box">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d30187.19764827078!2d73.130362404722!3d18.957947012211235!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3be7e6778b8f0053%3A0x3a5f266625ca59d9!2sGodrej%20City%2C%20Panvel!5e0!3m2!1sen!2sin!4v1769352609369!5m2!1sen!2sin"
                            width="100%" height="420" style="border:5px solid #fff; border-radius:12px;"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
                        </iframe>
                    </div>
                </div>

                <!-- RIGHT: CONNECTIVITY -->
                <div class="col-lg-6 col-md-12 d-flex align-content-center">
                    <div class="location_content">
                        <ul class="location_list">
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Mumbai–Pune Expressway</strong> – 2 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Rajiv Chowk Metro Station</strong> – 2 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Mumbai–Goa Highway</strong> – 10 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>NH-4 Highway</strong> – 15 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Orion Mall, Panvel</strong> – 2 km
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Orion Mall (City Drive)</strong> – 25 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Dhirubhai Ambani Hospital</strong> – 10 mins*
                            </li>
                            <li>
                                <img src="img/icons/location.png" alt="Location Icon">
                                <strong>Navi Mumbai International Airport</strong> – 20–40 mins*
                            </li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </section>


    <!-- gallery sections -->
    <section class="gallery_section" id="gallery">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-12 align-content-center">
                    <h2 class="section_title">Gallery</h2>
                    <p class="subheading">Godrej Nexspace, Panvel</p>
                </div>
                <div class="col-md-9 col-12">
                    <div class="wrapper position-relative">
                        <div class="center-slider">
                            <div class="gallery-card">
                                <a href="img/gallery/g1.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g1.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic Impression</span>
                                </a>
                            </div>
                            <div class="gallery-card">
                                <a href="img/gallery/g2.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g2.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic impression</span>
                                </a>
                            </div>
                            <div class="gallery-card">
                                <a href="img/gallery/g3.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g3.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic impression</span>
                                </a>
                            </div>
                            <div class="gallery-card">
                                <a href="img/gallery/g4.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g4.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic impression</span>
                                </a>
                            </div>
                            <div class="gallery-card">
                                <a href="img/gallery/g5.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g5.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic impression</span>
                                </a>
                            </div>
                            <div class="gallery-card">
                                <a href="img/gallery/g6.webp" class="with-caption image-link"
                                    title="Artistic Impression">
                                    <img src="img/gallery/g6.webp" alt="Godrej Nexspace Panvel" loading="lazy">
                                    <span>Artistic impression</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about builder section starts here -->
    <section class="about_builder">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="section_title">About Builder</h5>
                    <p>
                        Founded in 1897, Godrej Properties is one of India’s most trusted and pioneering real estate
                        developers, backed by the strong legacy of the Godrej Group. With over 125 years of excellence,
                        the brand has transformed skylines across major Indian cities through premium residential,
                        commercial, and township developments. Known for quality construction, sustainable practices,
                        and innovative design, Godrej Properties delivers thoughtfully planned spaces with modern
                        amenities and long-term value. Its commitment to customer trust, eco-friendly development, and
                        world-class architecture continues to set benchmarks in urban real estate.
                    </p>
                </div>
                <div class="col-md-6 align-self-center">
                    <div class="footer_form">
                        <div class="row">
                            <div class="col-12">
                                <h6>Your Next Address Awaits — Enquire Now</h6>
                            </div>
                            <form method="post" action="micrositeleads.php" id="form2">

                                <!-- Name -->
                                <input autocomplete="off" name="name" id="qSenderName_popup"
                                    class="form-control popup_form mb-4" placeholder="Your Full Name"
                                    pattern="[a-zA-Z ]{4,35}" required />

                                <!-- Email -->
                                <input autocomplete="off" name="email" id="qEmail_popup"
                                    class="form-control popup_form mb-4" placeholder="Email Address" type="email"
                                    required />

                                <!-- Phone -->
                                <input autocomplete="off" name="phone" id="qPhone_popup"
                                    class="form-control popup_form mb-4" placeholder="Phone Number" pattern="[0-9]{10}"
                                    maxlength="10" required />

                                <!-- Hidden Fields -->
                                <input type="hidden" name="projectname" value="GPanvel" />
                                <input type="hidden" name="form_source" value="Google Ads" />

                                <div class="inp-box d-flex align-items-center">
                                    <input type="checkbox" checked="" id="vehicle1" name="vehicle1"
                                        value="form-checkbox" style="width: 15px; margin-right: 8px;">
                                    <label for="vehicle1" class="inp-txt black" style="font-size: 10px; color: #000;"> I
                                        authorize company representatives to
                                        Call, SMS, Email or WhatsApp me about its products and offers. This consent
                                        overrides any registration for DNC/NDNC.</label>
                                </div>
                                <!-- Submit -->
                                <div class="col-lg-12 form-group text-center mt-3">
                                    <div class="advanced-button">
                                        <button class="button lg_btn submit-btn" type="submit" name="submit">
                                            <span class="btn-text">GET CALL BACK</span>
                                            <span class="btn-loader" aria-hidden="true"></span>
                                        </button>

                                        <!-- Honeypot -->
                                        <div class="form-group b-user-message">
                                            <input id="USER_MESSAGE" type="text" name="USER_MESSAGE" tabindex="-1"
                                                value="" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-response"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about builder section ends here -->
    <!-- footer section starts here -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <div class="disclaimer">
                        <p> Disclaimer - The content provided on this website is for information purposes only and does
                            not constitute an offer to avail any service. The prices mentioned are subject to change
                            without prior notice, and the availability of properties mentioned is not guaranteed.</p>
                        <p class="moretext" style="display: none;">The images displayed on the website are for
                            representation purposes only and may not reflect the actual properties accurately. Please
                            note that this is the official website of an authorized marketing partner. We may share data
                            with Real Estate Regulatory Authority (RERA) registered brokers/companies for further
                            processing as required. We may also send updates and information to the mobile number or
                            email ID registered with us. All rights reserved. The content, design, and information on
                            this website are protected by copyright and other intellectual property rights. Any
                            unauthorized use or reproduction of the content may violate applicable laws. For accurate
                            and up-to-date information regarding services, pricing, availability, and any other details,
                            it is advisable to contact us directly through the provided contact information on this
                            website. Thank you for visiting our website.</p>
                        <a href="javascript:void(0)" class="moreless-button">Read more</a>
                    </div>
                </div>
                <div class="col-12 text-center">
                    <div class="rera_details">
                        <P>Project Rera: Coming Soon
                            | Agent Rera: A041262504118
                        </P>
                        <p><a target="_blank" href="disclaimer.html">Disclaimer & Privacy Policy</a>
                            <!-- | Digital Media Planned By <a href="http://www.gtftechnologies.com/" target="_blank"> GTF Technologies -->
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer section ends here -->
    <a class="fixedIcons whatsapp"
        href="https://api.whatsapp.com/send?phone=+918147267372%20&amp;text=Hello,%20I%20am%20interested%20in%20knowing%20more%20details%20about%20Godrej%20Nexspace%20Panvel.%20Please%20get%20in%20touch%20with%20me%20and%20share%20your%20preferred%20time.%20My%20name%20is">
        <img src="img/icons/whatsapp.webp" alt="Godrej Nexspace Panvel" loading="lazy"> </a>
    <a class="fixedIcons phone" href="tel:+918147267372"> <img src="img/icons/phone.webp" alt="Godrej Nexspace Panvel"
            loading="lazy"> </a>
    <!-- mobile-section-footer -->
    <div class="mobile-section-footer">
        <a href="#" title="Enquire Now" data-bs-toggle="modal" data-bs-target="#enquireModal"> Enquire Now</a>
        <a
            href="https://api.whatsapp.com/send?phone=+918147267372  &amp;text=Hello, I am interested in knowing more details about Godrej Nexspace Panvel. Please get in touch with me and share your preferred time. My name is">
            WhatsApp</a>
        <a href="tel:+918147267372"> Call Now</a>
    </div>
    <!-- mobile-section-footer -->
    <!-- Enquire Now Modal -->
    <div class="modal fade" id="enquireModal" tabindex="-1" aria-labelledby="enquireModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" id="enquireModalLabel">Get Complete Project Details Now</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="micrositeleads.php" id="form3">

                        <!-- Name -->
                        <input autocomplete="off" name="name" id="qSenderName_popup"
                            class="form-control popup_form mb-4" placeholder="Your Full Name" pattern="[a-zA-Z ]{4,35}"
                            required />

                        <!-- Email -->
                        <input autocomplete="off" name="email" id="qEmail_popup" class="form-control popup_form mb-4"
                            placeholder="Email Address" type="email" required />

                        <!-- Phone -->
                        <input autocomplete="off" name="phone" id="qPhone_popup" class="form-control popup_form mb-4"
                            placeholder="Phone Number" pattern="[0-9]{10}" maxlength="10" required />

                        <!-- Hidden Fields -->
                        <input type="hidden" name="projectname" value="GPanvel" />
                        <input type="hidden" name="form_source" value="Google Ads" />
                        <div class="inp-box d-flex align-items-center">
                            <input type="checkbox" checked="" id="vehicle1" name="vehicle1" value="form-checkbox"
                                style="width: 15px; margin-right: 8px;">
                            <label for="vehicle1" class="inp-txt black" style="font-size: 10px; color: #000;"> I
                                authorize company representatives to
                                Call, SMS, Email or WhatsApp me about its products and offers. This consent
                                overrides any registration for DNC/NDNC.</label>
                        </div>
                        <!-- Submit -->
                        <div class="col-lg-12 form-group text-center">
                            <div class="advanced-button">
                                <button class="button lg_btn submit-btn" type="submit" name="submit">
                                    <span class="btn-text">GET CALL BACK</span>
                                    <span class="btn-loader" aria-hidden="true"></span>
                                </button>

                                <!-- Honeypot -->
                                <div class="form-group b-user-message">
                                    <input id="USER_MESSAGE" type="text" name="USER_MESSAGE" tabindex="-1" value=""
                                        autocomplete="off" />
                                </div>
                            </div>
                        </div>

                        <div class="form-response"></div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="form4" tabindex="-1" aria-labelledby="enquireModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" style="max-width: 900px;">
            <div class="modal-content">
                <div class="row">
                    <div class="col-md-6">
                        <!-- <img src="img/strip/blue-sapphire-PopUp.webp" alt="Godrej Nexspace Panvel" class="img-fluid"> -->
                    </div>
                    <div class="col-md-6">
                        <div class="modal-header">
                            <h6 class="modal-title" id="enquireModalLabel">Get a Call Back from Our Expert</h6>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body px-md-0">
                            <form method="post" action="micrositeleads.php" id="form4">

                                <!-- Name -->
                                <input autocomplete="off" name="name" id="qSenderName_popup"
                                    class="form-control popup_form mb-4" placeholder="Your Full Name"
                                    pattern="[a-zA-Z ]{4,35}" required />

                                <!-- Email -->
                                <input autocomplete="off" name="email" id="qEmail_popup"
                                    class="form-control popup_form mb-4" placeholder="Email Address" type="email"
                                    required />

                                <!-- Phone -->
                                <input autocomplete="off" name="phone" id="qPhone_popup"
                                    class="form-control popup_form mb-4" placeholder="Phone Number" pattern="[0-9]{10}"
                                    maxlength="10" required />

                                <!-- Hidden Fields -->
                                <input type="hidden" name="projectname" value="GPanvel" />
                                <input type="hidden" name="form_source" value="Google Ads" />

                                <div class="inp-box d-flex align-items-center">
                                    <input type="checkbox" checked="" id="vehicle1" name="vehicle1"
                                        value="form-checkbox" style="width: 15px; margin-right: 8px;">
                                    <label for="vehicle1" class="inp-txt black" style="font-size: 10px; color: #000;"> I
                                        authorize company representatives to
                                        Call, SMS, Email or WhatsApp me about its products and offers. This consent
                                        overrides any registration for DNC/NDNC.</label>
                                </div>
                                <!-- Submit -->
                                <div class="col-lg-12 form-group text-center">
                                    <div class="advanced-button">
                                        <button class="button lg_btn submit-btn" type="submit" name="submit">
                                            <span class="btn-text">GET CALL BACK</span>
                                            <span class="btn-loader" aria-hidden="true"></span>
                                        </button>

                                        <!-- Honeypot -->
                                        <div class="form-group b-user-message">
                                            <input id="USER_MESSAGE" type="text" name="USER_MESSAGE" tabindex="-1"
                                                value="" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-response"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="form5" tabindex="-1" aria-labelledby="enquireModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" style="max-width: 900px;">
            <div class="modal-content">
                <div class="row">
                    <div class="col-md-6">
                        <!-- <img src="img/strip/blue-sapphire-PopUp1.webp" alt="Godrej Nexspace Panvel" class="img-fluid"> -->
                    </div>
                    <div class="col-md-6">
                        <div class="modal-header">
                            <h6 class="modal-title" id="enquireModalLabel">Let’s Help You Find Your Dream Residence</h6>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body px-md-0">
                            <form method="post" action="micrositeleads.php" id="form5">

                                <!-- Name -->
                                <input autocomplete="off" name="name" id="qSenderName_popup"
                                    class="form-control popup_form mb-4" placeholder="Your Full Name"
                                    pattern="[a-zA-Z ]{4,35}" required />

                                <!-- Email -->
                                <input autocomplete="off" name="email" id="qEmail_popup"
                                    class="form-control popup_form mb-4" placeholder="Email Address" type="email"
                                    required />

                                <!-- Phone -->
                                <input autocomplete="off" name="phone" id="qPhone_popup"
                                    class="form-control popup_form mb-4" placeholder="Phone Number" pattern="[0-9]{10}"
                                    maxlength="10" required />

                                <!-- Hidden Fields -->
                                <input type="hidden" name="projectname" value="GPanvel" />
                                <input type="hidden" name="form_source" value="Google Ads" />
                                <div class="inp-box d-flex align-items-center">
                                    <input type="checkbox" checked="" id="vehicle1" name="vehicle1"
                                        value="form-checkbox" style="width: 15px; margin-right: 8px;">
                                    <label for="vehicle1" class="inp-txt black" style="font-size: 10px; color: #000;"> I
                                        authorize company representatives to
                                        Call, SMS, Email or WhatsApp me about its products and offers. This consent
                                        overrides any registration for DNC/NDNC.</label>
                                </div>
                                <!-- Submit -->
                                <div class="col-lg-12 form-group text-center">
                                    <div class="advanced-button">
                                        <button class="button lg_btn submit-btn" type="submit" name="submit">
                                            <span class="btn-text">GET CALL BACK</span>
                                            <span class="btn-loader" aria-hidden="true"></span>
                                        </button>

                                        <!-- Honeypot -->
                                        <div class="form-group b-user-message">
                                            <input id="USER_MESSAGE" type="text" name="USER_MESSAGE" tabindex="-1"
                                                value="" autocomplete="off" />
                                        </div>
                                    </div>
                                </div>

                                <div class="form-response"></div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        (function () {
            if (window.matchMedia("(max-width: 768px)").matches) {
                Array.from(document.getElementsByClassName('d_sm_none')).forEach(function (item) {
                    item.parentNode.removeChild(item);
                });
            } else {
                Array.from(document.getElementsByClassName('d_sm_block')).forEach(function (item) {
                    item.parentNode.removeChild(item);
                });
            }
        })()
    </script>

    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/slick.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/magnific-popup@1.1.0/dist/jquery.magnific-popup.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"></script>

    <script>
        $(".nav-link-custom").on("click", function (e) {
            var target = this.hash,
                $target = $(target);
            $("html, body")
                .stop()
                .animate(
                    {
                        scrollTop: $target.offset().top - 50,
                    },
                    900,
                    "swing",
                    function () {
                        window.location.hash = target;
                    }
                );
        });
    </script>

    <script>
        $(".moreless-button").click(function () {
            $(".moretext").slideToggle(200);
            if ($(".moreless-button").text() == "Read more") {
                $(this).text("Read less");
            } else {
                $(this).text("Read more");
            }
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const header = document.getElementById("header");
            const menuBtn = document.getElementById("menuBtn");
            const hamburger = document.getElementById("hamburger");
            const logoImg = document.getElementById("logoImg");
            const navLinks = document.querySelectorAll(".nav-link");
            const phoneEmail = document.querySelector(".phone-email");

            // Scroll behavior
            window.addEventListener("scroll", function () {
                if (window.scrollY > 50) {
                    header.classList.add("scrolled");
                    menuBtn.classList.add("scrolled");
                    hamburger.classList.add("scrolled");
                    if (phoneEmail) phoneEmail.classList.add("scrolled");
                    navLinks.forEach(link => link.classList.add("scrolled"));
                    // if (logoImg) logoImg.src = "img/logo.webp";
                } else {
                    header.classList.remove("scrolled");
                    menuBtn.classList.remove("scrolled");
                    hamburger.classList.remove("scrolled");
                    if (phoneEmail) phoneEmail.classList.remove("scrolled");
                    navLinks.forEach(link => link.classList.remove("scrolled"));
                    // if (logoImg) logoImg.src = "img/logo.webp";
                }
            });

            window.openMenu = function () {
                document.getElementById("sidebar").classList.add("open");
                document.getElementById("overlay").classList.add("show");
                document.body.style.overflow = "hidden";
            };

            window.closeMenu = function () {
                document.getElementById("sidebar").classList.remove("open");
                document.getElementById("overlay").classList.remove("show");
                document.body.style.overflow = "auto";
            };

            // ✅ Close sidebar on nav link click
            navLinks.forEach(link => {
                link.addEventListener("click", function () {
                    closeMenu(); // Call your existing function
                });
            });

            // Optional form toggle functionality
            const toggleBtn = document.querySelector(".form-toggle-btn");
            const form = document.querySelector(".slide-form");
            const closeBtn = document.querySelector(".form-close-btn");

            if (toggleBtn && form && closeBtn) {
                toggleBtn.addEventListener("click", () => form.classList.add("active"));
                closeBtn.addEventListener("click", () => form.classList.remove("active"));
            }
        });

        $(document).ready(function () {
            $('.center-slider').slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                centerMode: false,
                arrows: true,
                dots: false,
                infinite: true,
                speed: 500,
                autoplay: true,
                autoplaySpeed: 2000,
                prevArrow: '<div class="slide-arrow6 prev-arrow6"><img src="img/icons/left-arrow.png" alt="back" height="22"  loading="lazy"></div>',
                nextArrow: '<div class="slide-arrow6 next-arrow6"><img src="img/icons/right-arrow.png" alt="next" height="22"  loading="lazy"></div>',
                responsive: [
                    {
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                        }
                    }
                ]
            });
        });
    </script>

    <script>
        AOS.init({
            duration: 1000,
            once: false,
            easing: 'ease-in-out'
        });

        window.addEventListener('scroll', () => {
            AOS.refresh();
        });
    </script>

    <script>
        $(document).ready(function () {
            $('.without-caption').magnificPopup({
                type: 'image',
                closeOnContentClick: true,
                closeBtnInside: false,
                mainClass: 'mfp-no-margins mfp-with-zoom',
                image: {
                    verticalFit: true
                },
                zoom: {
                    enabled: true,
                    duration: 300
                }
            });

            $('.with-caption').magnificPopup({
                type: 'image',
                closeOnContentClick: true,
                closeBtnInside: false,
                mainClass: 'mfp-with-zoom mfp-img-mobile',
                image: {
                    verticalFit: true,
                    titleSrc: function (item) {
                        return item.el.attr('title') || '';
                    }
                },
                zoom: {
                    enabled: true,
                    duration: 300
                }
            });
        });
    </script>

    <script>
        $(window).ready(function () {
            setTimeout(function () {
                $('#enquireModal').modal("show")
            }, 3000)
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {

            document.querySelectorAll("form").forEach(function (form) {

                let submitted = false;

                form.addEventListener("submit", function () {

                    if (submitted) return false;
                    submitted = true;

                    const btn = form.querySelector(".submit-btn");
                    if (!btn) return;

                    btn.classList.add("loading", "disabled");

                    const text = btn.querySelector(".btn-text");
                    if (text) text.innerText = "Please wait...";
                });

            });

        });
    </script>
</body>

</html>